"""
Kernel‑to‑metric translation package.

This package contains helper functions to construct spatial envelopes from
Absolute Relativity (AR) reproduction kernels, solve Poisson equations on
discrete lattices, trace optical geodesics, and analyse resulting
potentials and fields.  All modules are pure Python and depend only on
NumPy/SciPy, so they can be installed easily in a fresh environment.

The top‑level run script lives in ``src/k2m/run_all.py`` and reads
configuration files from ``configs/`` to orchestrate full sweeps over
lattice sizes, gauges and smoothing scales.
"""

from importlib.metadata import version as _version

__all__ = [
    "envelope",
    "poisson",
    "optics",
    "analysis",
    "io_fphs",
]

try:
    __version__ = _version(__name__)
except Exception:
    __version__ = "0.0.0"
